#include "SimField.h"

namespace SimulationEngine
{

SimField::SimField()
{
	
}

SimField::SimField(DataField data): ISimEntity(data.GetDataEntityId())
{
	std::list<DataBody*>::iterator iter;
	IPhysicsController *physics = PhysicsControllerFactory::GetInstance()->GetPhysicsController();
	list<DataBody *> bodiesfield =data.GetBodies(); 	
	iter = bodiesfield.begin();
	while (iter!=bodiesfield.end())
	{
		bodies.push_back(physics->CreatePhysicalBody(data.GetDataEntityId(), (*iter)));
		iter++;
	}
}

SimField::~SimField()
{
}

list <IPhysicalBody *>  SimField::GetBodies()
{
	return bodies;
}

string SimField::GetSimString()
{
	return "";
}

void SimField::SetEntityPosition(float posx, float posy, float posz)
{
	
}

string SimField::PersistEntity()
{
	string toreturn = "<Entity Type=\"Field\"><Entity_id>";
	stringstream entityid;
	entityid<<this->GetEntityId();
		
	toreturn+= entityid.str()+ "</Entity_id><Bodies>";
	list <IPhysicalBody *>::iterator iterbodies;	
	iterbodies = bodies.begin();
	while (iterbodies!=bodies.end())
	{
		(*iterbodies)->UpdateData();
		toreturn += (*iterbodies)->GetDataBody()->ToString();
		iterbodies++;
	}
	toreturn += "</Bodies></Entity>";
	return toreturn;
}



}
